#include "RenderSystem.h"
#include "EntitySystem.h"
#include "Transform.h"

RenderSystem::RenderSystem()
	: m_myWindow(sf::VideoMode(768, 704), "SFML")
{
	AddRequiredComponent<RenderProperties>();
	AddRequiredComponent<TransformProperties>();
}

void RenderSystem::Update(float deltaSeconds)
{
	m_myWindow.clear();

	EntitySystem& entitySystem = EntitySystem::GetInstance();

	for (int i = 0; i < m_registeredEntities.size(); i++)
	{
		RenderProperties* pRenderProperties = entitySystem.GetComponent<RenderProperties>(m_registeredEntities[i]);
		TransformProperties* pTransformProperties = entitySystem.GetComponent<TransformProperties>(m_registeredEntities[i]);
		
		m_myWindow.draw(pRenderProperties->sprite, pTransformProperties->transform);
	}

	m_myWindow.display();
}
